<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisteredUserController;
use App\Http\Controllers\OrganizationOnboardingController;
use App\Http\Controllers\WebhookController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\BillingController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\CampaignController;
use App\Http\Controllers\KnowledgeBaseController;
use App\Http\Controllers\TicketController;
use App\Http\Controllers\Admin\EmbeddedSignupConfigurationController;
use App\Http\Controllers\Admin\OrganizationsController;
Route::get('/meta/webhook', [WebhookController::class, 'verify']);
Route::post('/meta/webhook', [WebhookController::class, 'handle']);
Route::get('/', function () {
    return redirect()->route('register');
});
Route::get('/register', [RegisteredUserController::class, 'create'])->name('register');
Route::post('/register', [RegisteredUserController::class, 'store']);
Route::get('/login', [LoginController::class, 'create'])->name('login');
Route::post('/login', [LoginController::class, 'store']);
Route::post('/logout', [LoginController::class, 'destroy'])->name('logout');
Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', function () {
        return Inertia::render('Dashboard/Index', [
            'organization' => auth()->user()->organization
        ]);
    })->name('dashboard');
    Route::get('/chat', [ChatController::class, 'index'])->name('chat');
    Route::get('/api/contacts/{contact}/messages', [ChatController::class, 'getMessages']);
    Route::post('/api/contacts/{contact}/messages', [ChatController::class, 'sendMessage']);
    Route::get('/api/contacts/{contact}/details', [ChatController::class, 'getContactDetails']);
    Route::post('/api/contacts/{contact}/assign', [ChatController::class, 'assignAgent']);
    Route::post('/api/contacts/{contact}/status', [ChatController::class, 'updateStatus']);
    Route::post('/api/contacts/{contact}/toggle-ai', [ChatController::class, 'toggleAi']);
    Route::post('/api/contacts/{contact}/note', [ChatController::class, 'updateNote']);
    Route::post('/api/contacts/{contact}/read', [ChatController::class, 'markAsRead']);
    Route::post('/api/chat/upload-media', [ChatController::class, 'uploadMedia']);
    Route::get('/api/chat/templates', [ChatController::class, 'getTemplates']);
    Route::get('/api/chat/search', [ChatController::class, 'searchConversations']);
    Route::get('/api/chat/canned-responses', [ChatController::class, 'getCannedResponses']);
    Route::post('/api/chat/canned-responses', [ChatController::class, 'storeCannedResponse']);
    Route::delete('/api/chat/canned-responses/{cannedResponse}', [ChatController::class, 'deleteCannedResponse']);
    // Tickets
    Route::get('/tickets', [TicketController::class, 'index'])->name('tickets.index');
    Route::post('/tickets', [TicketController::class, 'store'])->name('tickets.store');
    Route::put('/tickets/{ticket}', [TicketController::class, 'update'])->name('tickets.update');
    // Campaigns
    Route::get('/campaigns', [CampaignController::class, 'index'])->name('campaigns.index');
    Route::get('/campaigns/create', [CampaignController::class, 'create'])->name('campaigns.create');
    Route::post('/campaigns', [CampaignController::class, 'store'])->name('campaigns.store');
    // Knowledge Base
    Route::get('/knowledge-base', [KnowledgeBaseController::class, 'index'])->name('knowledge-base.index');
    Route::post('/knowledge-base', [KnowledgeBaseController::class, 'store'])->name('knowledge-base.store');
    Route::put('/knowledge-base/{knowledgeBase}', [KnowledgeBaseController::class, 'update'])->name('knowledge-base.update');
    Route::delete('/knowledge-base/{knowledgeBase}', [KnowledgeBaseController::class, 'destroy'])->name('knowledge-base.destroy');
    // Organization Settings
    Route::get('/settings', [SettingsController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingsController::class, 'update'])->name('settings.update');
    Route::post('/meta/callback', [OrganizationOnboardingController::class, 'handleMetaCallback'])->name('meta.callback');
    Route::post('/meta/disconnect', [OrganizationOnboardingController::class, 'disconnectMeta'])->name('meta.disconnect');
    // Billing Routes
    Route::get('/billing', [BillingController::class, 'index'])->name('billing');
    Route::post('/billing/subscribe', [BillingController::class, 'subscribe'])->name('billing.subscribe');
    // Super Admin Routes
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/settings', [AdminDashboardController::class, 'settings'])->name('admin.settings');
    Route::post('/admin/settings', [AdminDashboardController::class, 'updateSettings'])->name('admin.settings.update');
// Admin Added Routes
    Route::get('/admin/organizations', [OrganizationsController::class, 'index'])->name('admin.organizations');
    Route::post('/admin/organizations/{organization}/diagnostic', [OrganizationsController::class, 'diagnostic'])->name('admin.organizations.diagnostic');
    Route::get('/admin/users', function() { return Inertia::render('Admin/Users'); })->name('admin.users');
    Route::get('/admin/billing', function() { return Inertia::render('Admin/Billing'); })->name('admin.billing');
    Route::get('/admin/support', function() { return Inertia::render('Admin/Support'); })->name('admin.support');
    
    // Super Admin Team Management Routes
    Route::get('/admin/team', [\App\Http\Controllers\Admin\TeamController::class, 'index'])->name('admin.team');
    Route::post('/admin/team', [\App\Http\Controllers\Admin\TeamController::class, 'store'])->name('admin.team.store');
    Route::put('/admin/team/{user}', [\App\Http\Controllers\Admin\TeamController::class, 'update'])->name('admin.team.update');
    Route::delete('/admin/team/{user}', [\App\Http\Controllers\Admin\TeamController::class, 'destroy'])->name('admin.team.destroy');
    
    Route::get('/admin/roles', function() { return Inertia::render('Admin/Roles'); })->name('admin.roles');
    Route::get('/admin/configurations', function() {
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'UNAUTHORIZED ACCESS');
        }
        return Inertia::render('Admin/Configurations');
    })->name('admin.configurations');

    Route::get('/admin/configurations/embedded-signup', [EmbeddedSignupConfigurationController::class, 'edit'])->name('admin.configurations.embedded-signup.edit');
    Route::post('/admin/configurations/embedded-signup', [EmbeddedSignupConfigurationController::class, 'update'])->name('admin.configurations.embedded-signup.update');

    // Admin Settings Route already exists, add specific general settings
    Route::get('/admin/settings/general', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.general');

    // Dashboard Added Routes
    Route::get('/contacts', [\App\Http\Controllers\ContactController::class, 'index'])->name('contacts.index');
    Route::post('/contacts', [\App\Http\Controllers\ContactController::class, 'store'])->name('contacts.store');
    Route::put('/contacts/{contact}', [\App\Http\Controllers\ContactController::class, 'update'])->name('contacts.update');
    Route::delete('/contacts/{contact}', [\App\Http\Controllers\ContactController::class, 'destroy'])->name('contacts.destroy');
    Route::post('/contacts/bulk-delete', [\App\Http\Controllers\ContactController::class, 'bulkDelete'])->name('contacts.bulkDelete');
    Route::post('/contacts/bulk-group', [\App\Http\Controllers\ContactController::class, 'bulkGroup'])->name('contacts.bulkGroup');
    Route::post('/contacts/import', [\App\Http\Controllers\ContactController::class, 'import'])->name('contacts.import');
    Route::get('/contacts/export', [\App\Http\Controllers\ContactController::class, 'export'])->name('contacts.export');
    Route::post('/contacts/custom-fields', [\App\Http\Controllers\ContactController::class, 'updateCustomFields'])->name('contacts.customFields');
    Route::post('/contacts/column-preferences', [\App\Http\Controllers\ContactController::class, 'saveColumnPreferences'])->name('contacts.saveColumnPreferences');

    // Contact Notes (JSON API)
    Route::get('/contacts/{contact}/notes', [\App\Http\Controllers\ContactNoteController::class, 'index'])->name('contacts.notes.index');
    Route::post('/contacts/{contact}/notes', [\App\Http\Controllers\ContactNoteController::class, 'store'])->name('contacts.notes.store');
    Route::put('/contact-notes/{note}', [\App\Http\Controllers\ContactNoteController::class, 'update'])->name('contacts.notes.update');
    Route::delete('/contact-notes/{note}', [\App\Http\Controllers\ContactNoteController::class, 'destroy'])->name('contacts.notes.destroy');

    // Groups & Tags
    Route::post('/groups', [\App\Http\Controllers\GroupController::class, 'store'])->name('groups.store');
    Route::put('/groups/{group}', [\App\Http\Controllers\GroupController::class, 'update'])->name('groups.update');
    Route::delete('/groups/{group}', [\App\Http\Controllers\GroupController::class, 'destroy'])->name('groups.destroy');

    Route::post('/tags', [\App\Http\Controllers\TagController::class, 'store'])->name('tags.store');
    Route::put('/tags/{tag}', [\App\Http\Controllers\TagController::class, 'update'])->name('tags.update');
    Route::delete('/tags/{tag}', [\App\Http\Controllers\TagController::class, 'destroy'])->name('tags.destroy');

    Route::get('/templates', function() { return Inertia::render('Dashboard/Templates'); })->name('templates');
    Route::get('/automations', function() { return Inertia::render('Dashboard/Automations'); })->name('automations');
    
    // Team Management Routes (User Dashboard)
    Route::get('/team', [\App\Http\Controllers\TeamController::class, 'index'])->name('team');
    Route::post('/team', [\App\Http\Controllers\TeamController::class, 'store'])->name('team.store');
    Route::put('/team/{user}', [\App\Http\Controllers\TeamController::class, 'update'])->name('team.update');
    Route::delete('/team/{user}', [\App\Http\Controllers\TeamController::class, 'destroy'])->name('team.destroy');

    // Custom Role Management
    Route::post('/team/roles', [\App\Http\Controllers\OrganizationRoleController::class, 'store'])->name('team.roles.store');
    Route::put('/team/roles/{role}', [\App\Http\Controllers\OrganizationRoleController::class, 'update'])->name('team.roles.update');
    Route::delete('/team/roles/{role}', [\App\Http\Controllers\OrganizationRoleController::class, 'destroy'])->name('team.roles.destroy');
    
    Route::get('/developer', function() { return Inertia::render('Dashboard/Developer'); })->name('developer');

    // Organization Settings Routes
    Route::get('/settings/general', function() { return Inertia::render('Dashboard/Settings/General', ['organization' => auth()->user()->organization]); })->name('settings.general');
    Route::post('/settings/general', [SettingsController::class, 'updateGeneral'])->name('settings.general.update');

    Route::get('/settings/whatsapp', function() { return Inertia::render('Dashboard/Settings/Whatsapp', ['organization' => auth()->user()->organization]); })->name('settings.whatsapp');
    Route::post('/settings/whatsapp/manual', [SettingsController::class, 'updateManualWhatsappSettings'])->name('settings.whatsapp.manual');
    Route::get('/settings/contact-fields', function() { return Inertia::render('Dashboard/Settings/ContactFields', ['organization' => auth()->user()->organization]); })->name('settings.contact-fields');
    Route::get('/settings/tickets', function() { return Inertia::render('Dashboard/Settings/Tickets', ['organization' => auth()->user()->organization]); })->name('settings.tickets');
    Route::get('/settings/automations', function() { return Inertia::render('Dashboard/Settings/Automations', ['organization' => auth()->user()->organization]); })->name('settings.automations');

    // More Admin Settings
    Route::get('/admin/settings/timezone', function() { return Inertia::render('Admin/Settings/Timezone'); })->name('admin.settings.timezone');
    Route::get('/admin/settings/broadcast', function() { return Inertia::render('Admin/Settings/Broadcast'); })->name('admin.settings.broadcast');
    Route::get('/admin/settings/social-login', function() { return Inertia::render('Admin/Settings/SocialLogin'); })->name('admin.settings.social-login');
    Route::get('/admin/settings/storage', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.storage');
    Route::get('/admin/settings/payment', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.payment');
    Route::get('/admin/settings/smtp', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.smtp');
    Route::get('/admin/settings/email-templates', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.email-templates');
    Route::get('/admin/settings/subscriptions', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.subscriptions');
    Route::get('/admin/settings/billing-info', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.billing-info');
    Route::get('/admin/settings/tax', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.tax');
    Route::get('/admin/settings/coupons', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.coupons');
    Route::get('/admin/settings/languages', function() { return Inertia::render('Admin/Settings/General'); })->name('admin.settings.languages');
 
});
