<?php

namespace Database\Seeders;

use App\Models\Contact;
use App\Models\Message;
use App\Models\Organization;
use App\Models\Ticket;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // 1. Create Organization (Tenant)
        $org = Organization::create([
            'name' => 'Demo Company Inc.',
            'waba_id' => '1234567890',
            'system_user_token' => 'EAAD...dummy...token',
            'timezone' => 'UTC',
            'broadcast_driver' => 'reverb',
        ]);

        // 2. Create Super Admin User (System Owner)
        User::create([
            'organization_id' => null, // Super admins don't belong to a specific tenant
            'name' => 'Super Admin',
            'email' => 'superadmin@wabamanager.com',
            'password' => Hash::make('password'),
            'role' => 'System_Admin',
        ]);

        // 3. Create Tenant Owner (User)
        $tenantOwner = User::create([
            'organization_id' => $org->id,
            'name' => 'Tenant Owner',
            'email' => 'owner@democompany.com',
            'password' => Hash::make('password'),
            'role' => 'Owner',
        ]);

        // 4. Create Tenant Agent (User)
        $tenantAgent = User::create([
            'organization_id' => $org->id,
            'name' => 'Support Agent',
            'email' => 'agent@democompany.com',
            'password' => Hash::make('password'),
            'role' => 'Agent',
        ]);

        // 5. Create Contacts
        $contact1 = Contact::create([
            'organization_id' => $org->id,
            'first_name' => 'John',
            'last_name' => 'Doe',
            'phone' => '1234567890',
            'status' => 'Active',
        ]);

        $contact2 = Contact::create([
            'organization_id' => $org->id,
            'first_name' => 'Jane',
            'last_name' => 'Smith',
            'phone' => '0987654321',
            'status' => 'Active',
        ]);

        // 6. Create Messages (Conversation with John)
        Message::create([
            'organization_id' => $org->id,
            'contact_id' => $contact1->id,
            'meta_message_id' => 'wamid.111',
            'direction' => 'inbound',
            'type' => 'text',
            'content' => 'Hello! I need help with my order.',
            'status' => 'delivered',
            'created_at' => now()->subMinutes(10)
        ]);

        Message::create([
            'organization_id' => $org->id,
            'contact_id' => $contact1->id,
            'meta_message_id' => 'wamid.222',
            'direction' => 'outbound',
            'type' => 'text',
            'content' => 'Hi John! I can help with that. What is your order number?',
            'status' => 'read',
            'created_at' => now()->subMinutes(8)
        ]);

        // 7. Create Ticket for John assigned to Agent
        Ticket::create([
            'organization_id' => $org->id,
            'contact_id' => $contact1->id,
            'assigned_to' => $tenantAgent->id,
            'status' => 'open',
            'internal_notes' => 'Customer is asking about order delivery delay.',
        ]);
    }
}
