<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('canned_responses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('organization_id')->constrained()->onDelete('cascade');
            $table->string('title');
            $table->text('content');
            $table->string('shortcut')->nullable(); // e.g. /greeting
            $table->string('category')->nullable();
            $table->timestamps();

            $table->index(['organization_id', 'shortcut']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('canned_responses');
    }
};
