<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->foreignId('assigned_to')->nullable()->constrained('users')->nullOnDelete();
            $table->string('conversation_status')->default('new'); // new, open, pending, resolved, closed
            $table->boolean('ai_enabled')->default(false);
            $table->timestamp('last_message_at')->nullable();
            $table->integer('unread_count')->default(0);
            $table->timestamp('sla_deadline')->nullable();
            $table->text('internal_note')->nullable();

            $table->index(['organization_id', 'conversation_status']);
            $table->index(['organization_id', 'assigned_to']);
            $table->index(['organization_id', 'last_message_at']);
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropForeign(['assigned_to']);
            $table->dropColumn([
                'assigned_to', 'conversation_status', 'ai_enabled',
                'last_message_at', 'unread_count', 'sla_deadline', 'internal_note',
            ]);
        });
    }
};
