<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            if (!Schema::hasColumn('contacts', 'address')) {
                $table->text('address')->nullable()->after('country');
            }
            if (!Schema::hasColumn('contacts', 'po_box')) {
                $table->string('po_box', 50)->nullable()->after('address');
            }
        });
    }

    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn(['address', 'po_box']);
        });
    }
};
