<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            // Add missing fields from your requirements
            if (!Schema::hasColumn('contacts', 'phone_number')) {
                $table->string('phone_number')->after('phone')->index(); // WhatsApp routing
            }
            
            if (!Schema::hasColumn('contacts', 'dob')) {
                $table->date('dob')->nullable()->after('email'); // Date of birth
            }
            
            if (!Schema::hasColumn('contacts', 'gender')) {
                $table->enum('gender', ['male', 'female', 'other'])->nullable()->after('dob');
            }
            
            // Modify existing columns if needed
            if (Schema::hasColumn('contacts', 'city')) {
                $table->string('city')->nullable()->change();
            }
            
            if (Schema::hasColumn('contacts', 'country')) {
                $table->string('country')->nullable()->change();
            }
            
            if (!Schema::hasColumn('contacts', 'is_opted_out')) {
                $table->boolean('is_opted_out')->default(false)->after('country'); // Compliance (STOP rule)
            }
            
            if (!Schema::hasColumn('contacts', 'custom_values')) {
                $table->json('custom_values')->nullable()->after('is_opted_out'); // Industry-specific data
            }
            
            if (!Schema::hasColumn('contacts', 'last_marketed_at')) {
                $table->timestamp('last_marketed_at')->nullable()->after('last_messaged_at');
            }
            
            if (!Schema::hasColumn('contacts', 'timezone')) {
                $table->string('timezone')->nullable()->after('custom_values');
            }
            
            // Add indexes for performance (only if they don't exist)
            if (!Schema::hasIndex('contacts', 'contacts_organization_id_phone_number_index')) {
                $table->index(['organization_id', 'phone_number']);
            }
            
            if (!Schema::hasIndex('contacts', 'contacts_organization_id_is_opted_out_index')) {
                $table->index(['organization_id', 'is_opted_out']);
            }
            
            if (!Schema::hasIndex('contacts', 'contacts_organization_id_status_index')) {
                $table->index(['organization_id', 'status']);
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn([
                'phone_number',
                'dob', 
                'gender',
                'is_opted_out',
                'custom_values',
                'last_marketed_at',
                'timezone'
            ]);
        });
    }
};
