<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::table('users')
            ->where('email', 'superadmin@wabamanager.com')
            ->update(['role' => 'System_Admin', 'organization_id' => null]);

        DB::table('users')
            ->where('email', 'owner@democompany.com')
            ->update(['role' => 'Owner']);

        DB::table('users')
            ->where('email', 'agent@democompany.com')
            ->update(['role' => 'Agent']);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::table('users')
            ->whereIn('email', [
                'superadmin@wabamanager.com',
                'owner@democompany.com',
                'agent@democompany.com',
            ])->update(['role' => 'Agent']);
    }
};
