<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->date('dob')->nullable()->after('email');
            $table->string('timezone')->nullable()->after('country');
            $table->boolean('is_opted_out')->default(false)->after('timezone');
            $table->json('custom_values')->nullable()->after('is_opted_out');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('contacts', function (Blueprint $table) {
            $table->dropColumn(['dob', 'timezone', 'is_opted_out', 'custom_values']);
        });
    }
};
