<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('organizations', function (Blueprint $table) {
            // Check if column exists before adding it
            if (!Schema::hasColumn('organizations', 'slug')) {
                $table->string('slug')->unique()->nullable()->after('name');
            }
            if (!Schema::hasColumn('organizations', 'trial_ends_at')) {
                $table->timestamp('trial_ends_at')->nullable()->after('timezone');
            }
            if (!Schema::hasColumn('organizations', 'broadcast_driver')) {
                $table->string('broadcast_driver')->default('reverb')->after('timezone'); // reverb or pusher
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('organizations', function (Blueprint $table) {
            if (Schema::hasColumn('organizations', 'slug')) {
                $table->dropColumn('slug');
            }
            if (Schema::hasColumn('organizations', 'trial_ends_at')) {
                $table->dropColumn('trial_ends_at');
            }
            if (Schema::hasColumn('organizations', 'broadcast_driver')) {
                $table->dropColumn('broadcast_driver');
            }
        });
    }
};
