<?php

namespace App\Services\Ai\Contracts;

interface AiDriverInterface
{
    /**
     * Send a chat request to the AI model.
     *
     * @param array $messages Standardized array of messages (e.g., [['role' => 'user', 'content' => 'Hello']])
     * @param array $options Additional driver-specific options
     * @return string The text response from the AI model
     */
    public function chat(array $messages, array $options = []): string;
}
