<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class Tag extends BaseTenantModel
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'organization_id',
        'name',
        'color',
    ];

    /**
     * Get all of the contacts that are assigned this tag.
     */
    public function contacts()
    {
        return $this->morphedByMany(Contact::class, 'taggable');
    }
}
