<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;

class CustomFieldDefinition extends BaseTenantModel
{
    use HasFactory;

    protected $fillable = [
        'organization_id',
        'key',
        'label',
        'type',
        'required',
        'default_visible',
        'sort_order',
        'options',
        'default_value',
    ];

    protected $casts = [
        'required' => 'boolean',
        'default_visible' => 'boolean',
        'options' => 'array',
    ];

    public function scopeOrdered($query)
    {
        return $query->orderBy('sort_order');
    }

    public function scopeVisible($query)
    {
        return $query->where('default_visible', true);
    }
}
