<?php

namespace App\Http\Controllers;

use App\Models\Tag;
use Illuminate\Http\Request;

class TagController extends Controller
{
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'color' => 'nullable|string|max:255'
        ]);

        $existing = Tag::where('organization_id', auth()->user()->organization_id)
            ->where('name', $validated['name'])
            ->first();

        if ($existing) {
            return back()->withErrors(['name' => 'A tag with this name already exists.']);
        }

        $validated['organization_id'] = auth()->user()->organization_id;
        Tag::create($validated);

        return back()->with('success', 'Tag created successfully.');
    }

    public function update(Request $request, Tag $tag)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'color' => 'nullable|string|max:255'
        ]);

        $existing = Tag::where('organization_id', auth()->user()->organization_id)
            ->where('name', $validated['name'])
            ->where('id', '!=', $tag->id)
            ->first();

        if ($existing) {
            return back()->withErrors(['name' => 'A tag with this name already exists.']);
        }

        $tag->update($validated);

        return back()->with('success', 'Tag updated successfully.');
    }

    public function destroy(Tag $tag)
    {
        $tag->delete();
        return back()->with('success', 'Tag deleted successfully.');
    }
}
