<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\PlatformSettingsService;
use Illuminate\Http\Request;
use Inertia\Inertia;

class EmbeddedSignupConfigurationController extends Controller
{
    public function edit(PlatformSettingsService $settings)
    {
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'UNAUTHORIZED ACCESS');
        }

        return Inertia::render('Admin/Configurations/EmbeddedSignup', [
            'config' => [
                'app_id' => $settings->get('meta.app_id', config('meta.app_id'), false),
                'config_id' => $settings->get('meta.config_id', config('meta.config_id'), false),
                'business_id' => $settings->get('meta.business_id', config('meta.business_id'), false),
                'redirect_uri' => $settings->get('meta.redirect_uri', config('meta.redirect_uri'), false),
                'has_app_secret' => $settings->has('meta.app_secret') || !empty(config('meta.app_secret')),
                'has_webhook_verify_token' => $settings->has('meta.webhook_verify_token') || !empty(config('meta.webhook_verify_token')),
            ],
        ]);
    }

    public function update(Request $request, PlatformSettingsService $settings)
    {
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'UNAUTHORIZED ACCESS');
        }

        $validated = $request->validate([
            'app_id' => ['required', 'string'],
            'config_id' => ['required', 'string'],
            'app_secret' => ['nullable', 'string'],
            'business_id' => ['nullable', 'string'],
            'redirect_uri' => ['nullable', 'string'],
            'webhook_verify_token' => ['nullable', 'string'],
        ]);

        $settings->set('meta.app_id', $validated['app_id'], false);
        $settings->set('meta.config_id', $validated['config_id'], false);
        $settings->set('meta.business_id', $validated['business_id'] ?? null, false);
        $settings->set('meta.redirect_uri', $validated['redirect_uri'] ?? null, false);

        if (!empty($validated['webhook_verify_token'])) {
            $settings->set('meta.webhook_verify_token', $validated['webhook_verify_token'], true);
        }

        if (!empty($validated['app_secret'])) {
            $settings->set('meta.app_secret', $validated['app_secret'], true);
        }

        return back()->with('success', 'Embedded Signup configuration saved successfully.');
    }
}
