<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MetaError;
use App\Models\Organization;
use App\Models\User;
use Illuminate\Http\Request;
use Inertia\Inertia;

class DashboardController extends Controller
{
    /**
     * Show the admin dashboard.
     */
    public function index()
    {
        // Require super admin role
        if (!auth()->user()->isSuperAdmin()) {
            $role = auth()->user()->role ?? 'NULL';
            abort(403, 'UNAUTHORIZED ACCESS - Role is: ' . $role);
        }

        $stats = [
            'total_organizations' => Organization::count(),
            'total_users' => User::count(),
            'active_wabas' => Organization::whereNotNull('waba_id')->count(),
            'recent_meta_errors' => MetaError::withoutGlobalScopes()->where('created_at', '>=', now()->subDays(7))->count(),
        ];

        $recentOrganizations = Organization::withCount('users')
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        $recentErrors = MetaError::withoutGlobalScopes()
            ->with('organization')
            ->orderBy('created_at', 'desc')
            ->take(10)
            ->get();

        return Inertia::render('Admin/Index', [
            'stats' => $stats,
            'recentOrganizations' => $recentOrganizations,
            'recentErrors' => $recentErrors,
        ]);
    }

    public function settings()
    {
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'UNAUTHORIZED ACCESS');
        }

        return Inertia::render('Admin/Settings');
    }

    public function updateSettings(Request $request)
    {
        if (!auth()->user()->isSuperAdmin()) {
            abort(403, 'UNAUTHORIZED ACCESS');
        }

        // Handle global settings update
        return back()->with('success', 'Global settings updated successfully.');
    }
}







