<?php

namespace App\Exports;

use App\Models\Contact;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class ContactsExport implements FromQuery, WithHeadings, WithMapping
{
    protected $query;

    public function __construct($query)
    {
        $this->query = $query;
    }

    public function query()
    {
        return $this->query;
    }

    public function headings(): array
    {
        return [
            'ID',
            'First Name',
            'Last Name',
            'Phone',
            'Email',
            'Date of Birth',
            'City',
            'Country',
            'Timezone',
            'Status',
            'Opted Out',
            'Custom Values',
            'Created At',
            'Groups',
            'Tags'
        ];
    }

    public function map($contact): array
    {
        return [
            $contact->id,
            $contact->first_name,
            $contact->last_name,
            $contact->phone,
            $contact->email,
            $contact->dob ? $contact->dob->format('Y-m-d') : null,
            $contact->city,
            $contact->country,
            $contact->timezone,
            $contact->status,
            $contact->is_opted_out ? 'Yes' : 'No',
            $contact->custom_values ? json_encode($contact->custom_values) : null,
            $contact->created_at->format('Y-m-d H:i:s'),
            $contact->groups->pluck('name')->implode(', '),
            $contact->tags->pluck('name')->implode(', '),
        ];
    }
}
